#********************************************************************************
#   If you should have any comments, suggestions or improvements to these  
#   samples, we welcome you to contact us at SampleCode@melissadata.com.  
#   Also visit our developer bulletin board at forum.melissadata.com.
#********************************************************************************

require 'mdAddrRubyWrapper'


# ********************** LICENSE STRINGS ***********************
#       To unlock the full function ality of Address Object,   
#   please call a sales representative at 1-800-MELISSA ext. 3 
#           (1-800-635-4772 x3) for a license string.          
#        Without a valid license string, AddressCheck will     
#                  only verify Nevada addresses.               
#              REPLACE "DEMO" with LICENSE STRING                    

#   SetLicenseString will also check for a valid license in the 
#   MDADDR_LICENSE(Environment) variable. This allows you to  
#   modify the license without recompiling the project
# **************************************************************
License = "DEMO"


# ********************** DATA FILE PATH  ***********************
# File location path is set to the default Data File location. *
# Change this value if you installed the data files to a       *
# different folder.                                            *
# The Data Files Directory must contain the following files:   *
# mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str           *
# **************************************************************
DataPath = "/usr/melissadata"

addrObj = MdAddrRubyWrapper::MdAddr.new() 

if(addrObj.SetLicenseString(License) == false)
  print "Invalid License: Running in DEMO MODE.\n"

end

#Set Path and Initialize
addrObj.SetPathToUSFiles(DataPath)

#CASS required add-ons for highest level of validation. 
#Should be used by non-demo users
# addrObj.SetPathToDPVDataFiles(DataPath)
# addrObj.SetPathToSuiteLinkDataFiles(DataPath)
# addrObj.SetPathToLACSLinkDataFiles(DataPath)

#ADD-ONS
# addrObj.SetPathToRBDIFiles(DataPath)
# addrObj.SetPathToCanadaFiles(DataPath)
# addrObj.SetPathToSuiteFinderDataFiles(DataPath)

if(addrObj.InitializeDataFiles() == false)
  print addrObj.GetInitializeErrorString()
  Process.exit
end

print "\n"
print "=================================================\n"
print "        ADDRESS OBJECT RUBY SAMPLE\n"
print "      Build Number: "  + addrObj.GetBuildNumber()  + "\n"
print "     Database Date: "  + addrObj.GetDatabaseDate()  + "\n"
print "   Expiration Date: "  + addrObj.GetExpirationDate()  + "\n"
print "=================================================\n"
print "\n"
print "   Enter Company: "
temp = gets
company = temp.chomp
print "   Enter Address: "
temp = gets
address = temp.chomp
print "  Enter Address2: "
temp = gets
address2 = temp.chomp
print "      Enter City: "
temp = gets
city = temp.chomp
print "     Enter State: "
temp = gets
state = temp.chomp
print "       Enter Zip: "
temp = gets
zip = temp.chomp
print " Enter Last Name: "
last = temp.chomp
temp = gets

#Set the Input properties
addrObj.ClearProperties()
addrObj.SetCompany(company)
addrObj.SetAddress(address)
addrObj.SetAddress2(address2)
addrObj.SetCity(city)
addrObj.SetState(state)
addrObj.SetZip(zip)
addrObj.SetLastName(last)

#Process the address
addrObj.VerifyAddress()


print "\n"
print "============ Address Output ============ \n"
print "         Company: "  + addrObj.GetCompany()  + "\n"
print "         Address: "  + addrObj.GetAddress()  + "\n"
print "        Address2: "  + addrObj.GetAddress2()  + "\n"
print "           Suite: "  + addrObj.GetSuite()  + "\n"
print " Private Mailbox: "  + addrObj.GetPrivateMailbox()  + "\n"
print "            City: "  + addrObj.GetCity()  + "\n"
print "           State: "  + addrObj.GetState()  + "\n"
print "             Zip: "  + addrObj.GetZip()  + "\n"
print "           Plus4: "  + addrObj.GetPlus4()  + "\n"
print "\n"

# The level of verification is returned a delimited string, so we parse it out...
print "Results Codes...\n"
ResultsString = addrObj.GetResults()
# Address could be verified
if (((ResultsString.include? "AS01") == true) or ((ResultsString.include? "AS02") == true) or ((ResultsString.include? "AS03") == true))
   if ((ResultsString.include? "AS01") == true)
      print " AS01: Full Address Matched to Postal Database and is deliverable\n"
   elsif ((ResultsString.include? "AS02") == true)
      print " AS02: Address street matched to USPS database but a suite was missing or invalid\n"
   elsif ((ResultsString.include? "AS03") == true)
      print " AS03: Valid physical address not serviced by the USPS\n"
   end
end

# Display additional level of verification/comments
if ((ResultsString.include? "AS09") == true)
    print " AS09: Foreign Postal Code Detected\n"
end
if ((ResultsString.include? "AS10") == true)
    print " AS10: Address Matched to CMRA\n"
end
if ((ResultsString.include? "AS13") == true)
    print " AS13: Address has been Updated by LACSLink\n"
end 
if ((ResultsString.include? "AS14") == true)
    print " AS14: Suite Appended by SuiteLink\n"
end
if ((ResultsString.include? "AS15") == true)  
    print " AS15: Suite Appended by SuiteFinder\n"
end
if ((ResultsString.include? "AS16") == true)
    print " AS16: Address is vacant.\n" 
end
if ((ResultsString.include? "AS17") == true) 
    print " AS17: Alternate delivery.\n"
end
if ((ResultsString.include? "AS18") == true)
    print " AS18: Artificially created adresses detected, DPV processing terminated at this point\n"
end
if ((ResultsString.include? "AS20") == true)
    print " AS20: Address Deliverable by USPS only\n" 
end 
if ((ResultsString.include? "AS21") == true) 
    print " AS21: Alternate Address Suggestion Found.\n"
end
if ((ResultsString.include? "AS22") == true)
    print " AS22: No Alternate Address Suggestion Found\n"
end
if ((ResultsString.include? "AS23") == true)
    print " AS23: Extraneous information found\n" 
end 


# there was an error in verifying the address
if ((ResultsString.include? "AE") == true)
    print " Address could not be verified\n"
end
if ((ResultsString.include? "AE01") == true)
    print " AE01: Zip Code Error\n"
end
if ((ResultsString.include? "AE02") == true) 
    print " AE02: Unknown Street Error\n"
end
if ((ResultsString.include? "AE03") == true) 
    print " AE03: Component Mismatch Error\n"
end
if ((ResultsString.include? "AE04") == true)  
    print " AE04: Non-Deliverable Address Error\n"
end
if ((ResultsString.include? "AE05") == true)   
    print " AE05: Multiple Match Error\n"
end
if ((ResultsString.include? "AE06") == true)  
    print " AE06: Early Warning System Error\n"
end
if ((ResultsString.include? "AE07") == true)   
    print " AE07: Missing Minimum Address Input\n"
end
if ((ResultsString.include? "AE08") == true) 
    print " AE08: Suite Range Invalid Error\n"
end
if ((ResultsString.include? "AE09") == true)  
    print " AE09: Suite Range Missing Error\n"
end
if ((ResultsString.include? "AE10") == true) 
    print " AE10: Primary Range Invalid Error\n"
end
if ((ResultsString.include? "AE11") == true)  
    print " AE11: Primary Range Missing Error\n"
end
if ((ResultsString.include? "AE12") == true)  
    print " AE12: PO, HC, or RR Box Number Invalid\n"
end
if ((ResultsString.include? "AE13") == true) 
    print " AE13: PO, HC, or RR Box Number Missing\n"
end
if ((ResultsString.include? "AE14") == true) 
    print " AE14: CMRA Secondary Missing Error\n"
end

# or program can not attempt address lookup
if ((ResultsString.include? "AE15") == true) 
    print " AE15: Demo Mode, valid license needed for full processing\n"
end
if ((ResultsString.include? "AE16") == true)  
    print " AE16: Expired Database, please update\n"
end 

if ((ResultsString.include? "AE17") == true)  
    print " AE17: Unnecessary Suite Error\n"
end
if ((ResultsString.include? "AE19") == true) 
    print " AE19: Max time for FindSuggestion exceeded\n"
end
if ((ResultsString.include? "AE20") == true) 
    print " AE20: FindSuggestion cannot be used\n"
end

# there was a change made to the input data
if ((ResultsString.include? "AC01") == true)
    print " AC01: ZIP Code Change\n"
end
if ((ResultsString.include? "AC02") == true)
    print " AC02: State Change\n"
end
if ((ResultsString.include? "AC03") == true)
    print " AC03: City Change\n"
end 
if ((ResultsString.include? "AC04") == true)
    print " AC04: Base/Alternate Change\n"
end
if ((ResultsString.include? "AC05") == true)  
    print " AC05: Alias Name Change\n"
end
if ((ResultsString.include? "AC06") == true)
    print " AC06: Address1/Address2 Swap.\n" 
end
if ((ResultsString.include? "AC07") == true) 
    print " AC07: Address1/Company Swap\n"
end
if ((ResultsString.include? "AC08") == true)
    print " AC08: Plus4 Change\n"
end
if ((ResultsString.include? "AC09") == true)
    print " AC09: Urbanization Change\n" 
end 
if ((ResultsString.include? "AC10") == true) 
    print " AC10: Street Name Change.\n"
end
if ((ResultsString.include? "AC11") == true)
    print " AC11: Street Suffix Change\n"
end
if ((ResultsString.include? "AC12") == true)
    print " AC12: Street Directional Change\n" 
end
if ((ResultsString.include? "AC13") == true)
    print " AC13: Suite Name Change\n" 
end

print "\n"
print "              Carrier Route: "  + addrObj.GetCarrierRoute()  + "\n"
print "          DeliveryPointCode: "  + addrObj.GetDeliveryPointCode()  + "\n"
print "     DeliveryPointChckDigit: "  + addrObj.GetDeliveryPointCheckDigit()  + "\n"
print "              DPV Footnotes: "  + addrObj.GetDPVFootnotes()  + "\n"
print "\n"
print "          Address Type Code: "  + addrObj.GetAddressTypeCode()  + "\n"
print "        Address Type String: "  + addrObj.GetAddressTypeString()  + "\n"
print "          City Abbreviation: "  + addrObj.GetCityAbbreviation()  + "\n"
print "                County Name: "  + addrObj.GetCountyName()  + "\n"
print "                County Fips: "  + addrObj.GetCountyFips()  + "\n"
print "               Country Code: "  + addrObj.GetCountryCode()  + "\n"
print "     Congressional District: "  + addrObj.GetCongressionalDistrict()  + "\n"
print "                  Time Zone: "  + addrObj.GetTimeZone()  + "\n"
print "             Time Zone Code: "  + addrObj.GetTimeZoneCode()  + "\n"
print "               Urbanization: "  + addrObj.GetUrbanization()  + "\n"
print "                   Zip Type: "  + addrObj.GetZipType()  + "\n"
print "\n" 
print "       Parsed Address Range: "  + addrObj.GetParsedAddressRange()  + "\n"        
print "       Parsed Pre Direction: "  + addrObj.GetParsedPreDirection()  + "\n"        
print "         Parsed Street Name: "  + addrObj.GetParsedStreetName()  + "\n"          
print "              Parsed Suffix: "  + addrObj.GetParsedSuffix()  + "\n"               
print "      Parsed Post Direction: "  + addrObj.GetParsedPostDirection()  + "\n"       
print "          Parsed Suite Name: "  + addrObj.GetParsedSuiteName()  + "\n"           
print "         Parsed Suite Range: "  + addrObj.GetParsedSuiteRange()  + "\n"          
print "   ParsedPrivateMailboxName: "  + addrObj.GetParsedPrivateMailboxName()  + "\n"    
print " ParsedPrivateMailboxNumber: "  + addrObj.GetParsedPrivateMailboxNumber()  + "\n"  
print "             Parsed Garbage: "  + addrObj.GetParsedGarbage()  + "\n"             
print "\n" 
print "                        MSA: "  + addrObj.GetMsa()  + "\n"                       
print "                       PMSA: "  + addrObj.GetPmsa()  + "\n"                      
print "                       CMRA: "  + addrObj.GetCMRA()  + "\n"                   
print "            Private Mailbox: "  + addrObj.GetPrivateMailbox()  + "\n"           
print "\n"                         
print "                 ELot Order: "  + addrObj.GetELotOrder()  + "\n"               
print "                ELot Number: "  + addrObj.GetELotNumber()  + "\n"              
print "                       LACS: "  + addrObj.GetLACS()  + "\n"                          
print "          LACSLinkIndicator: "  + addrObj.GetLACSLinkIndicator()  + "\n"        
print "         LACSLinkReturnCode: "  + addrObj.GetLACSLinkReturnCode()  + "\n"       
print "     Suite Link Return Code: "  + addrObj.GetSuiteLinkReturnCode()  + "\n"   
print "                        EWS: "  + addrObj.GetEWSFlag()  + "\n"                      
print "                       RBDI: "  + addrObj.GetRBDI()  + "\n"  

print "===============================\n"                     
